function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = World_Economy_Cartel_dAC.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(70, 131);
g1(1,25)=T(29)+T(32);
g1(1,28)=T(29);
g1(1,11)=T(31);
g1(1,42)=exp(y(25))*exp(y(28))*T(75);
g1(1,43)=T(106);
g1(1,46)=T(107);
g1(1,59)=exp(y(25));
g1(1,19)=T(226);
g1(1,21)=T(30)*(-(exp(y(25))*exp(y(46))));
g1(1,80)=(-1);
g1(1,119)=params(21);
g1(2,26)=T(24)*(-exp(y(26)))+exp(y(26))*y(63)+y(73)*(-(T(28)*params(4)*params(4)*exp(y(26)*params(4))));
g1(2,42)=(-exp(y(26)))*T(75);
g1(2,43)=(-exp(y(26)))*T(88);
g1(2,63)=exp(y(26));
g1(2,73)=(-(T(28)*params(4)*exp(y(26)*params(4))));
g1(2,82)=(-1);
g1(2,121)=params(21);
g1(3,27)=y(72)*(-(T(27)*params(4)*params(4)*exp(y(27)*params(4))))+exp(y(27))*y(63)+y(68)*y(38)*T(27)*params(4)*(params(4)-1)*(params(4)-1)*exp(y(27)*(params(4)-1));
g1(3,38)=y(68)*T(27)*params(4)*(params(4)-1)*exp(y(27)*(params(4)-1));
g1(3,63)=exp(y(27));
g1(3,68)=y(38)*T(27)*params(4)*(params(4)-1)*exp(y(27)*(params(4)-1));
g1(3,72)=(-(T(27)*params(4)*exp(y(27)*params(4))));
g1(3,81)=(-1);
g1(3,120)=params(21);
g1(4,25)=T(29);
g1(4,28)=T(24)*T(33)+y(76)*(-exp(y(28)))+exp(y(28))*y(75);
g1(4,42)=T(33)*T(75);
g1(4,43)=T(33)*T(88);
g1(4,48)=T(99);
g1(4,55)=T(24)*T(104);
g1(4,75)=exp(y(28));
g1(4,76)=(-exp(y(28)));
g1(4,84)=(-1);
g1(4,123)=params(21);
g1(5,29)=y(76)*(-exp(y(29)))+exp(y(29))*y(74);
g1(5,74)=exp(y(29));
g1(5,76)=(-exp(y(29)));
g1(5,83)=(-1);
g1(5,122)=params(21);
g1(6,30)=T(35);
g1(6,34)=T(41);
g1(6,104)=T(221);
g1(6,109)=params(21)*exp(y(30))*params(6)*exp(params(5)*(y(34)-y(104)));
g1(6,71)=exp(y(30));
g1(6,112)=params(21)*(-(exp(y(30))*(1-exp((-y(104)))*exp(y(34)))));
g1(6,116)=T(228);
g1(7,31)=T(37);
g1(7,35)=T(110);
g1(7,109)=params(21)*params(6)*exp(params(5)*y(35))*exp(y(31));
g1(7,70)=exp(y(31));
g1(7,111)=params(21)*(-((1-exp(y(35)))*exp(y(31))));
g1(7,115)=params(21)*(-(exp(y(35))*exp(y(31))));
g1(8,32)=T(38);
g1(8,71)=(-(params(7)*exp(y(32))));
g1(8,73)=exp(y(32));
g1(8,114)=params(21)*(-((1-params(7))*exp(y(32))));
g1(9,33)=T(39);
g1(9,70)=(-(params(7)*exp(y(33))));
g1(9,72)=exp(y(33));
g1(9,113)=params(21)*(-((1-params(7))*exp(y(33))));
g1(10,30)=T(41);
g1(10,34)=params(21)*y(118)*(-exp(y(34)))+T(113);
g1(10,104)=T(222);
g1(10,109)=params(21)*exp(y(30))*params(6)*params(5)*exp(params(5)*(y(34)-y(104)));
g1(10,112)=T(227);
g1(10,116)=T(228);
g1(10,118)=params(21)*(-exp(y(34)));
g1(10,126)=(-params(21));
g1(10,127)=T(42);
g1(11,94)=y(66)*T(108);
g1(11,31)=T(110);
g1(11,35)=T(36)+T(45)+y(69)*exp(y(102))*params(6)*params(5)*(params(5)-1)*(params(5)-1)*exp(y(35)*(params(5)-1))+T(116)+params(21)*y(109)*exp(y(31))*params(6)*params(5)*params(5)*exp(params(5)*y(35));
g1(11,95)=y(66)*(-(exp(y(102))*(-exp(y(35)))));
g1(11,102)=y(69)*T(43)+y(66)*T(44);
g1(11,109)=params(21)*exp(y(31))*params(6)*params(5)*exp(params(5)*y(35));
g1(11,66)=T(44);
g1(11,69)=T(43);
g1(11,111)=params(21)*(-(exp(y(31))*(-exp(y(35)))));
g1(11,115)=params(21)*(-(exp(y(35))*exp(y(31))));
g1(11,125)=(-params(21));
g1(11,128)=T(42);
g1(12,36)=exp(y(36))*y(62);
g1(12,62)=exp(y(36));
g1(13,11)=T(30)*y(19)*(-(exp(y(46))*(-exp(y(11)))));
g1(13,46)=T(117);
g1(13,19)=T(30)*(-(exp(y(46))*(1-exp(y(11)))));
g1(13,66)=1;
g1(13,67)=(-params(7));
g1(13,21)=exp(y(46))*T(30);
g1(14,27)=y(68)*T(27)*params(4)*(params(4)-1)*exp(y(27)*(params(4)-1));
g1(14,46)=T(30)*y(20)*(-(exp(y(46))*(1-params(7))));
g1(14,20)=T(30)*(-(exp(y(46))*(1-params(7))));
g1(14,67)=1;
g1(14,68)=params(4)*exp(y(27)*(params(4)-1))*T(27);
g1(15,39)=T(8)*y(76)+y(59)*(-(params(11)*T(12)*T(120)))+y(58)*(-(T(48)*T(124)+params(11)*T(47)*params(11)*T(47)*T(125)));
g1(15,40)=y(59)*(-(T(46)*params(11)*T(49)));
g1(15,13)=y(58)*(-(params(11)*T(47)*T(125)*T(140)));
g1(15,42)=y(58)*(-(params(11)*T(47)*T(85)*T(125)));
g1(15,47)=y(58)*(-(params(11)*T(47)*T(96)*T(125)));
g1(15,58)=(-(params(11)*T(47)*T(48)));
g1(15,59)=(-(params(11)*T(12)*T(46)));
g1(15,76)=T(8);
g1(16,39)=y(59)*(-(T(46)*params(11)*T(49)));
g1(16,40)=y(63)*(-exp(y(40)))+y(61)*(-(T(5)*T(19)*T(16)*exp(T(1)*y(47))*(1-params(11))*params(3)*T(130)))+y(60)*(-(T(17)*T(3)*T(16)*exp(T(1)*y(47))*(1-params(11))*(1-params(3))*T(130)))+exp(y(40))*y(58)+y(59)*(-(T(14)*params(11)*T(130)));
g1(16,13)=y(61)*T(142)+y(60)*(-(T(17)*T(143)));
g1(16,42)=T(131);
g1(16,47)=T(134);
g1(16,58)=exp(y(40));
g1(16,59)=(-(T(14)*params(11)*T(49)));
g1(16,60)=(-(T(17)*T(3)*T(16)*T(51)));
g1(16,61)=(-(T(5)*T(19)*T(16)*T(50)));
g1(16,63)=(-exp(y(40)));
g1(16,85)=(-1);
g1(16,124)=params(21);
g1(17,97)=params(21)*y(105)*(-(T(58)*params(11)*T(126)*T(127)));
g1(17,98)=params(21)*y(106)*(-(T(62)*(T(54)*T(65)*T(136)+T(55)*T(67)*T(136))))+params(21)*y(107)*T(137);
g1(17,41)=T(20)*y(63)+params(21)*y(109)*(-(T(20)*(1-params(10))))+params(21)*y(105)*(-(T(61)*T(156)+T(58)*T(58)*T(127)))+params(21)*y(106)*(-(T(62)*(T(64)*T(65)*T(154)+T(54)*T(64)*T(67)+T(54)*T(64)*T(67)+T(55)*T(64)*T(158))))+params(21)*y(107)*(-(T(53)*(T(67)*T(69)*T(70)+T(68)*T(69)*T(158)+T(67)*T(69)*T(70)+T(65)*T(69)*T(161))))+params(21)*y(108)*(-(exp((1-params(3))*y(99))*exp(T(1)*y(103))*params(3)*params(3)*exp(params(3)*y(41))));
g1(17,99)=params(21)*y(105)*(-(T(61)*T(194)+T(58)*T(127)*T(52)*T(57)*T(55)*T(193)))+params(21)*y(106)*(-((T(54)*T(64)*T(65)+T(55)*T(64)*T(67))*T(195)+T(62)*(T(54)*T(64)*T(66)*T(55)*T(193)+T(55)*T(64)*T(196))))+params(21)*y(107)*(-((T(68)*T(67)*T(69)+T(65)*T(69)*T(70))*T(193)+T(53)*(T(68)*T(69)*T(196)+T(70)*T(69)*T(66)*T(55)*T(193))))+params(21)*y(108)*(-(exp(T(1)*y(103))*params(3)*exp(params(3)*y(41))*(1-params(3))*exp((1-params(3))*y(99))));
g1(17,103)=params(21)*y(105)*(-(T(61)*T(213)+T(58)*T(127)*T(59)*(1-params(11))*T(1)*exp(T(1)*y(103))))+params(21)*y(106)*(-(T(62)*T(215)))+params(21)*y(107)*(-(T(53)*T(216)))+params(21)*y(108)*(-(exp((1-params(3))*y(99))*params(3)*exp(params(3)*y(41))*T(1)*exp(T(1)*y(103))));
g1(17,105)=params(21)*(-(T(58)*T(61)));
g1(17,106)=params(21)*(-(T(62)*(T(54)*T(64)*T(65)+T(55)*T(64)*T(67))));
g1(17,107)=params(21)*T(71);
g1(17,108)=params(21)*(-(exp((1-params(3))*y(99))*exp(T(1)*y(103))*params(3)*exp(params(3)*y(41))));
g1(17,63)=T(20);
g1(17,109)=params(21)*(-(T(20)*(1-params(10))));
g1(18,25)=exp(y(25))*exp(y(28))*T(75);
g1(18,26)=(-exp(y(26)))*T(75);
g1(18,28)=T(33)*T(75);
g1(18,39)=y(58)*(-(T(85)*params(11)*T(47)*T(125)));
g1(18,40)=T(131);
g1(18,13)=y(62)*(-(T(76)*exp(T(1)*y(47))*params(3)*exp(y(13)*params(3))))+y(61)*(-(T(78)*(T(19)*T(18)*T(79)*T(139)+T(16)*T(18)*T(141))+T(5)*(T(18)*T(80)*T(141)+T(19)*T(18)*T(145))))+y(60)*(-(T(17)*(T(15)*T(80)*T(138)+T(3)*T(15)*T(145))+T(82)*T(146)))+y(58)*(-(T(85)*T(125)*T(140)+T(48)*T(148)));
g1(18,14)=y(65)*T(166);
g1(18,42)=(T(33)-exp(y(26)))*T(173)+y(65)*(-(params(1)*T(173)/T(26)))+T(4)*y(64)+y(62)*(-(exp(T(1)*y(47))*exp(y(13)*params(3))*(1-params(3))*T(76)))+y(61)*T(178)+y(60)*T(182)+y(58)*(-(T(85)*T(85)*T(125)+T(48)*T(183)))+params(21)*y(110)*T(185);
g1(18,99)=params(21)*y(110)*(-((-(T(75)*T(200)))/(T(24)*T(24))));
g1(18,15)=y(65)*T(201);
g1(18,43)=(T(33)-exp(y(26)))*T(203)+y(65)*(-(params(1)*T(203)/T(26)))+params(21)*y(110)*T(205);
g1(18,100)=params(21)*y(110)*(-((-(T(75)*params(1)*exp(y(100))*T(199)))/(T(24)*T(24))));
g1(18,47)=y(62)*(-(T(76)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(47))))+T(189)+T(190)+y(58)*(-(T(48)*T(191)+T(85)*T(96)*T(125)));
g1(18,48)=T(192);
g1(18,55)=T(75)*T(104);
g1(18,58)=(-(T(48)*T(85)));
g1(18,60)=T(83);
g1(18,61)=T(81);
g1(18,62)=T(77);
g1(18,64)=T(4);
g1(18,65)=(-(params(1)*T(75)/T(26)));
g1(18,110)=params(21)*(-((-(T(75)*T(87)))/(T(24)*T(24))));
g1(19,25)=T(106);
g1(19,26)=(-exp(y(26)))*T(88);
g1(19,28)=T(33)*T(88);
g1(19,14)=y(65)*T(167);
g1(19,42)=(T(33)-exp(y(26)))*T(186)+y(65)*(-(params(1)*T(186)/T(26)))+params(21)*y(110)*(-(T(187)/T(184)));
g1(19,99)=params(21)*y(110)*(-((-(T(88)*T(200)))/(T(24)*T(24))));
g1(19,15)=y(65)*T(202);
g1(19,43)=(T(33)-exp(y(26)))*T(206)+y(65)*(-(params(1)*T(206)/T(26)))+exp(y(43))*y(63)+params(21)*y(110)*(-((T(24)*T(24)*(-(T(87)*T(206)))-(-(T(87)*T(88)))*T(204))/T(184)));
g1(19,100)=params(21)*y(110)*(-((-(T(88)*params(1)*exp(y(100))*T(199)))/(T(24)*T(24))));
g1(19,48)=T(88)*T(98);
g1(19,55)=T(88)*T(104);
g1(19,63)=exp(y(43));
g1(19,65)=T(89);
g1(19,110)=params(21)*(-((-(T(87)*T(88)))/(T(24)*T(24))));
g1(20,44)=exp(y(44))*y(61)+T(90);
g1(20,46)=T(90);
g1(20,61)=exp(y(44));
g1(20,18)=T(30)*(-(exp(y(44))*exp(y(46))));
g1(21,45)=exp(y(45))*y(60)+y(64)*(-(T(21)*T(209)));
g1(21,60)=exp(y(45));
g1(21,64)=(-(T(21)*T(91)));
g1(22,25)=T(107);
g1(22,11)=T(114);
g1(22,37)=T(117);
g1(22,38)=T(30)*y(20)*(-(exp(y(46))*(1-params(7))));
g1(22,44)=T(90);
g1(22,46)=T(92);
g1(22,18)=T(30)*(-(exp(y(46))*(1+exp(y(44))-params(10))));
g1(22,65)=exp(y(46));
g1(22,19)=T(30)*(-(exp(y(46))*(exp(y(25))*exp(y(11))+y(37)*(1-exp(y(11)))-params(6)*exp(params(5)*y(11)))));
g1(22,20)=T(30)*(-(y(38)*exp(y(46))*(1-params(7))));
g1(22,21)=T(30)*(exp(y(46))*params(6)*params(5)*exp(y(11)*(params(5)-1))-exp(y(46))*(exp(y(25))-y(37)));
g1(23,39)=y(58)*(-(T(96)*params(11)*T(47)*T(125)));
g1(23,40)=T(134);
g1(23,13)=y(62)*T(149)+y(61)*(-(T(5)*T(150)))+y(60)*(-(T(17)*T(151)))+y(58)*(-(T(96)*T(125)*T(140)+T(48)*T(95)*T(84)*T(139)));
g1(23,42)=y(62)*(-(T(76)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(47))))+T(189)+T(190)+y(58)*(-(T(96)*T(85)*T(125)+T(48)*T(191)));
g1(23,47)=y(62)*T(210)+y(61)*(-(T(5)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(47))))+y(60)*T(211)+y(58)*(-(T(96)*T(96)*T(125)+T(48)*T(212)));
g1(23,58)=(-(T(48)*T(96)));
g1(23,60)=(-(T(17)*T(3)*T(16)*T(94)));
g1(23,61)=(-(T(5)*T(19)*T(16)*T(93)));
g1(23,62)=(-(exp(y(42)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(47))));
g1(23,78)=1;
g1(23,117)=params(21)*(-params(15));
g1(23,129)=T(42)*(-params(16));
g1(24,28)=T(99);
g1(24,6)=T(103);
g1(24,10)=T(111);
g1(24,42)=T(192);
g1(24,43)=T(88)*T(98);
g1(24,48)=T(24)*T(218)+T(219);
g1(24,55)=T(24)*T(224);
g1(24,63)=T(102);
g1(24,71)=T(101);
g1(24,75)=T(100);
g1(24,77)=1;
g1(24,87)=1;
g1(24,126)=(-params(21));
g1(25,80)=1;
g1(26,81)=1;
g1(27,82)=1;
g1(28,83)=1;
g1(29,84)=1;
g1(30,85)=1;
g1(31,28)=T(24)*T(104);
g1(31,42)=T(75)*T(104);
g1(31,43)=T(88)*T(104);
g1(31,48)=T(24)*T(220);
g1(31,55)=exp(y(55))*y(79)+T(24)*T(225);
g1(31,79)=exp(y(55));
g1(32,86)=1;
g1(33,87)=1;
g1(34,39)=(-(params(11)*T(47)*T(48)));
g1(34,40)=exp(y(40));
g1(34,13)=(-(T(48)*T(140)));
g1(34,42)=(-(T(48)*T(85)));
g1(34,47)=(-(T(48)*T(96)));
g1(35,25)=exp(y(25));
g1(35,39)=(-(params(11)*T(12)*T(46)));
g1(35,40)=(-(T(14)*params(11)*T(49)));
g1(36,40)=(-(T(17)*T(3)*T(16)*T(51)));
g1(36,13)=(-(T(17)*T(146)));
g1(36,42)=T(83);
g1(36,45)=exp(y(45));
g1(36,47)=(-(T(17)*T(3)*T(16)*T(94)));
g1(37,40)=(-(T(5)*T(19)*T(16)*T(50)));
g1(37,13)=(-(T(5)*(T(19)*T(18)*T(79)*T(139)+T(16)*T(18)*T(141))));
g1(37,42)=T(81);
g1(37,44)=exp(y(44));
g1(37,47)=(-(T(5)*T(19)*T(16)*T(93)));
g1(38,36)=exp(y(36));
g1(38,13)=(-(exp(y(42)*(1-params(3)))*exp(T(1)*y(47))*params(3)*exp(y(13)*params(3))));
g1(38,42)=T(77);
g1(38,47)=(-(exp(y(42)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(47))));
g1(39,26)=exp(y(26));
g1(39,27)=exp(y(27));
g1(39,6)=params(6)*exp(params(5)*(y(10)-y(48)))*exp(y(6));
g1(39,7)=params(6)*exp(params(5)*y(11))*exp(y(7));
g1(39,10)=exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(48)));
g1(39,11)=exp(y(7))*params(6)*params(5)*exp(params(5)*y(11));
g1(39,40)=(-exp(y(40)));
g1(39,13)=(-(exp(y(13))*(1-params(10))));
g1(39,41)=T(20);
g1(39,43)=exp(y(43));
g1(39,48)=T(102);
g1(40,42)=T(4);
g1(40,45)=(-(T(21)*T(91)));
g1(41,101)=(-(exp(y(102))*exp(y(101))));
g1(41,102)=(-(exp(y(102))*(1+exp(y(101))-params(10))));
g1(42,14)=(-((-(params(1)*T(24)*T(165)))/(T(26)*T(26))));
g1(42,42)=(-(params(1)*T(75)/T(26)));
g1(42,15)=(-((-(params(1)*T(24)*exp(y(15))*T(164)))/(T(26)*T(26))));
g1(42,43)=T(89);
g1(42,46)=exp(y(46));
g1(43,94)=T(108);
g1(43,35)=T(44);
g1(43,37)=1;
g1(43,95)=(-(exp(y(102))*(1-exp(y(35)))));
g1(43,102)=(-(exp(y(102))*(exp(y(35))*exp(y(94))+(1-exp(y(35)))*y(95)-params(6)*exp(params(5)*y(35)))));
g1(44,37)=(-params(7));
g1(44,38)=1;
g1(44,96)=(-(exp(y(102))*(1-params(7))));
g1(44,102)=(-(exp(y(102))*(1-params(7))*y(96)));
g1(45,27)=y(38)*T(27)*params(4)*(params(4)-1)*exp(y(27)*(params(4)-1));
g1(45,38)=params(4)*exp(y(27)*(params(4)-1))*T(27);
g1(46,94)=(-(exp(y(102))*exp(y(94))));
g1(46,35)=T(43);
g1(46,95)=exp(y(102));
g1(46,102)=T(105);
g1(47,7)=(-(exp(y(7))*(1-exp(y(11)))));
g1(47,31)=exp(y(31));
g1(47,33)=(-(params(7)*exp(y(33))));
g1(47,11)=(-(exp(y(7))*(-exp(y(11)))));
g1(48,6)=(-(exp(y(6))*(1-exp((-y(48)))*exp(y(10)))));
g1(48,30)=exp(y(30));
g1(48,32)=(-(params(7)*exp(y(32))));
g1(48,10)=T(112);
g1(48,48)=T(101);
g1(49,27)=(-(T(27)*params(4)*exp(y(27)*params(4))));
g1(49,9)=(-((1-params(7))*exp(y(9))));
g1(49,33)=exp(y(33));
g1(50,26)=(-(T(28)*params(4)*exp(y(26)*params(4))));
g1(50,8)=(-((1-params(7))*exp(y(8))));
g1(50,32)=exp(y(32));
g1(51,29)=exp(y(29));
g1(51,7)=(-(exp(y(7))*exp(y(11))));
g1(51,11)=(-(exp(y(7))*exp(y(11))));
g1(52,28)=exp(y(28));
g1(52,6)=T(109);
g1(52,10)=T(109);
g1(52,48)=T(100);
g1(53,28)=(-exp(y(28)));
g1(53,29)=(-exp(y(29)));
g1(53,39)=T(8);
g1(54,48)=1;
g1(54,130)=(-1);
g1(55,16)=(-params(15));
g1(55,47)=1;
g1(55,131)=(-1);
g1(55,22)=(-params(16));
g1(56,10)=(-exp(y(10)));
g1(56,55)=exp(y(55));
g1(57,1)=1;
g1(57,25)=(-1);
g1(57,49)=1;
g1(58,3)=1;
g1(58,27)=(-1);
g1(58,50)=1;
g1(59,2)=1;
g1(59,26)=(-1);
g1(59,51)=1;
g1(60,5)=1;
g1(60,29)=(-1);
g1(60,52)=1;
g1(61,4)=1;
g1(61,28)=(-1);
g1(61,53)=1;
g1(62,12)=1;
g1(62,40)=(-1);
g1(62,54)=1;
g1(63,11)=(-1);
g1(63,56)=1;
g1(63,23)=1;
g1(64,10)=(-1);
g1(64,17)=(-1);
g1(64,48)=1;
g1(64,57)=1;
g1(64,24)=1;
g1(65,126)=(-1);
g1(65,88)=1;
g1(66,125)=(-1);
g1(66,89)=1;
g1(67,117)=(-1);
g1(67,90)=1;
g1(68,16)=(-1);
g1(68,91)=1;
g1(69,11)=(-1);
g1(69,92)=1;
g1(70,10)=(-1);
g1(70,93)=1;

end
